// Generated by CoffeeScript 1.7.1
(function() {
  var __slice = [].slice,
    __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  Vex.Flow.VexTab = (function() {
    var L, newError;

    VexTab.DEBUG = false;

    L = function() {
      var args;
      args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      if (Vex.Flow.VexTab.DEBUG) {
        return typeof console !== "undefined" && console !== null ? console.log.apply(console, ["(Vex.Flow.VexTab)"].concat(__slice.call(args))) : void 0;
      }
    };

    newError = function(object, msg) {
      return new Vex.RERR("ParseError", "" + msg + " in line " + object._l + " column " + object._c);
    };

    function VexTab(artist) {
      this.artist = artist;
      this.reset();
    }

    VexTab.prototype.reset = function() {
      this.valid = false;
      return this.elements = false;
    };

    VexTab.prototype.isValid = function() {
      return this.valid;
    };

    VexTab.prototype.parseStaveOptions = function(options) {
      var clefs, e, error, notation_option, num_strings, option, params, voices, _i, _len, _ref, _ref1, _ref2;
      params = {};
      if (options == null) {
        return params;
      }
      notation_option = null;
      for (_i = 0, _len = options.length; _i < _len; _i++) {
        option = options[_i];
        error = function(msg) {
          return newError(option, msg);
        };
        params[option.key] = option.value;
        switch (option.key) {
          case "notation":
          case "tablature":
            notation_option = option;
            if ((_ref = option.value) !== "true" && _ref !== "false") {
              throw error("'" + option.key + "' must be 'true' or 'false'");
            }
            break;
          case "key":
            if (!_.has(Vex.Flow.keySignature.keySpecs, option.value)) {
              throw error("Invalid key signature '" + option.value + "'");
            }
            break;
          case "clef":
            clefs = ["treble", "bass", "tenor", "alto", "percussion", "none"];
            if (_ref1 = option.value, __indexOf.call(clefs, _ref1) < 0) {
              throw error("'clef' must be one of " + (clefs.join(', ')));
            }
            break;
          case "voice":
            voices = ["top", "bottom", "new"];
            if (_ref2 = option.value, __indexOf.call(voices, _ref2) < 0) {
              throw error("'voice' must be one of " + (voices.join(', ')));
            }
            break;
          case "time":
            try {
              new Vex.Flow.TimeSignature(option.value);
            } catch (_error) {
              e = _error;
              throw error("Invalid time signature: '" + option.value + "'");
            }
            break;
          case "tuning":
            try {
              new Vex.Flow.Tuning(option.value);
            } catch (_error) {
              e = _error;
              throw error("Invalid tuning: '" + option.value + "'");
            }
            break;
          case "strings":
            num_strings = parseInt(option.value);
            if (num_strings < 4 || num_strings > 8) {
              throw error("Invalid number of strings: " + num_strings);
            }
            break;
          default:
            throw error("Invalid option '" + option.key + "'");
        }
      }
      if (params.notation === "false" && params.tablature === "false") {
        throw newError(notation_option, "Both 'notation' and 'tablature' can't be invisible");
      }
      return params;
    };

    VexTab.prototype.parseCommand = function(element) {
      if (element.command === "bar") {
        this.artist.addBar(element.type);
      }
      if (element.command === "tuplet") {
        this.artist.makeTuplets(element.params.tuplet, element.params.notes);
      }
      if (element.command === "annotations") {
        this.artist.addAnnotations(element.params);
      }
      if (element.command === "rest") {
        this.artist.addRest(element.params);
      }
      if (element.command === "command") {
        return this.artist.runCommand(element.params, element._l, element._c);
      }
    };

    VexTab.prototype.parseChord = function(element) {
      L("parseChord:", element);
      return this.artist.addChord(_.map(element.chord, function(note) {
        return _.pick(note, 'time', 'dot', 'fret', 'abc', 'octave', 'string', 'articulation', 'decorator');
      }), element.articulation, element.decorator);
    };

    VexTab.prototype.parseFret = function(note) {
      return this.artist.addNote(_.pick(note, 'time', 'dot', 'fret', 'string', 'articulation', 'decorator'));
    };

    VexTab.prototype.parseABC = function(note) {
      return this.artist.addNote(_.pick(note, 'time', 'dot', 'fret', 'abc', 'octave', 'string', 'articulation', 'decorator'));
    };

    VexTab.prototype.parseStaveElements = function(notes) {
      var element, _i, _len, _results;
      L("parseStaveElements:", notes);
      _results = [];
      for (_i = 0, _len = notes.length; _i < _len; _i++) {
        element = notes[_i];
        if (element.time) {
          this.artist.setDuration(element.time, element.dot);
        }
        if (element.command) {
          this.parseCommand(element);
        }
        if (element.chord) {
          this.parseChord(element);
        }
        if (element.abc) {
          _results.push(this.parseABC(element));
        } else if (element.fret) {
          _results.push(this.parseFret(element));
        } else {
          _results.push(void 0);
        }
      }
      return _results;
    };

    VexTab.prototype.parseStaveText = function(text_line) {
      var bartext, command, createNote, font, justification, position, smooth, str, text, _i, _len, _results;
      if (!_.isEmpty(text_line)) {
        this.artist.addTextVoice();
      }
      position = 0;
      justification = "center";
      smooth = true;
      font = null;
      bartext = (function(_this) {
        return function() {
          return _this.artist.addTextNote("", 0, justification, false, true);
        };
      })(this);
      createNote = (function(_this) {
        return function(text) {
          var e, ignore_ticks;
          ignore_ticks = false;
          if (text[0] === "|") {
            ignore_ticks = true;
            text = text.slice(1);
          }
          try {
            return _this.artist.addTextNote(text, position, justification, smooth, ignore_ticks);
          } catch (_error) {
            e = _error;
            throw newError(str, "Bad text or duration. Did you forget a comma?" + e);
          }
        };
      })(this);
      _results = [];
      for (_i = 0, _len = text_line.length; _i < _len; _i++) {
        str = text_line[_i];
        text = str.text.trim();
        if (text.match(/\.font=.*/)) {
          font = text.slice(6);
          _results.push(this.artist.setTextFont(font));
        } else if (text[0] === ":") {
          _results.push(this.artist.setDuration(text));
        } else if (text[0] === ".") {
          command = text.slice(1);
          switch (command) {
            case "center":
            case "left":
            case "right":
              _results.push(justification = command);
              break;
            case "strict":
              _results.push(smooth = false);
              break;
            case "smooth":
              _results.push(smooth = true);
              break;
            case "bar":
            case "|":
              _results.push(bartext());
              break;
            default:
              _results.push(position = parseInt(text.slice(1), 10));
          }
        } else if (text === "|") {
          _results.push(bartext());
        } else if (text.slice(0, 2) === "++") {
          _results.push(this.artist.addTextVoice());
        } else {
          _results.push(createNote(text));
        }
      }
      return _results;
    };

    VexTab.prototype.generate = function() {
      var e, option, options, stave, _i, _j, _len, _len1, _ref, _ref1, _results;
      _ref = this.elements;
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        stave = _ref[_i];
        switch (stave.element) {
          case "stave":
          case "tabstave":
            this.artist.addStave(stave.element, this.parseStaveOptions(stave.options));
            if (stave.notes != null) {
              this.parseStaveElements(stave.notes);
            }
            if (stave.text != null) {
              _results.push(this.parseStaveText(stave.text));
            } else {
              _results.push(void 0);
            }
            break;
          case "voice":
            this.artist.addVoice(this.parseStaveOptions(stave.options));
            if (stave.notes != null) {
              this.parseStaveElements(stave.notes);
            }
            if (stave.text != null) {
              _results.push(this.parseStaveText(stave.text));
            } else {
              _results.push(void 0);
            }
            break;
          case "options":
            options = {};
            _ref1 = stave.params;
            for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
              option = _ref1[_j];
              options[option.key] = option.value;
            }
            try {
              _results.push(this.artist.setOptions(options));
            } catch (_error) {
              e = _error;
              throw newError(stave, e.message);
            }
            break;
          default:
            throw newError(stave, "Invalid keyword '" + stave.element + "'");
        }
      }
      return _results;
    };

    VexTab.prototype.parse = function(code) {
      var line, stripped_code;
      vextab_parser.parseError = function(message, hash) {
        L("VexTab parse error: ", message, hash);
        message = "Unexpected text '" + hash.text + "' at line " + hash.loc.first_line + " column " + hash.loc.first_column + ".";
        throw new Vex.RERR("ParseError", message);
      };
      if (code == null) {
        throw new Vex.RERR("ParseError", "No code");
      }
      L("Parsing:\n" + code);
      stripped_code = (function() {
        var _i, _len, _ref, _results;
        _ref = code.split(/\r\n|\r|\n/);
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          line = _ref[_i];
          _results.push(line.trim());
        }
        return _results;
      })();
      this.elements = vextab_parser.parse(stripped_code.join("\n"));
      if (this.elements) {
        this.generate();
        this.valid = true;
      }
      return this.elements;
    };

    return VexTab;

  })();

}).call(this);
