// Generated by CoffeeScript 1.7.1
(function() {
  var __slice = [].slice,
    __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  Vex.Flow.Player = (function() {
    var Fraction, INSTRUMENTS, L, RESOLUTION, drawDot, getOverlay, noteValues;

    Player.DEBUG = false;
    Player.INSTRUMENTS_LOADED = {};

    L = function() {
      var args;
      args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      if (Vex.Flow.Player.DEBUG) {
        return typeof console !== "undefined" && console !== null ? console.log.apply(console, ["(Vex.Flow.Player)"].concat(__slice.call(args))) : void 0;
      }
    };

    Fraction = Vex.Flow.Fraction;

    RESOLUTION = Vex.Flow.RESOLUTION;

    noteValues = Vex.Flow.Music.noteValues;

    drawDot = Vex.drawDot;
      
    INSTRUMENTS = {
      "acoustic_grand_piano": 0,
      "acoustic_guitar_nylon": 24,
      "acoustic_guitar_steel": 25,
      "electric_guitar_jazz": 26,
      "distortion_guitar": 30,
      "electric_bass_finger": 33,
      "electric_bass_pick": 34,
      "trumpet": 56,
      "brass_section": 61,
      "soprano_sax": 64,
      "alto_sax": 65,
      "tenor_sax": 66,
      "baritone_sax": 67,
      "flute": 73,
      "synth_drum": 118
    };

    function Player(artist, options) {
      this.artist = artist;
      L("Initializing player: ", options);
      this.options = {
        instrument: "acoustic_grand_piano",
        tempo: 120,
        show_controls: true,
        soundfont_url: "/soundfont/",
        overlay_class: "vextab-player"
      };
      if (options != null) {
        _.extend(this.options, options);
      }
      L("Using soundfonts in: " + this.options.soundfont_url);
      this.interval_id = null;
      this.paper = null;
      this.reset();
    }

    Player.prototype.setArtist = function(artist) {
      this.artist = artist;
      return this.reset();
    };

    Player.prototype.setTempo = function(tempo) {
      L("New tempo: ", tempo);
      this.options.tempo = tempo;
      return this.reset();
    };

    Player.prototype.setInstrument = function(instrument) {
      L("New instrument: ", instrument);
      if (__indexOf.call(_.keys(INSTRUMENTS), instrument) < 0) {
        throw new Vex.RERR("PlayerError", "Invalid instrument: " + instrument);
      }
      this.options.instrument = instrument;
      return this.reset();
    };

    Player.prototype.reset = function() {
      this.artist.attachPlayer(this);
      this.tick_notes = {};
      this.all_ticks = [];
      this.tpm = this.options.tempo * (RESOLUTION / 4);
      this.refresh_rate = 25;
      this.ticks_per_refresh = this.tpm / (60 * (1000 / this.refresh_rate));
      this.total_ticks = 0;
      if (this.marker != null) {
        this.marker.remove();
        this.marker = null;
      }
      return this.stop();
    };

    getOverlay = function(context, scale, overlay_class) {
      var canvas, ctx, height, overlay, ps, width;
      canvas = context.canvas;
      height = canvas.height;
      width = canvas.width;
      overlay = $('<canvas>');
      overlay.css("position", "absolute");
      overlay.css("left", 0);
      overlay.css("top", 0);
      overlay.addClass(overlay_class);
      $(canvas).after(overlay);
      ctx = Vex.Flow.Renderer.getCanvasContext(overlay.get(0), width, height);
      ctx.scale(scale, scale);
      ps = new paper.PaperScope();
      ps.setup(overlay.get(0));
      return {
        paper: ps,
        canvas: overlay.get(0)
      };
    };

    Player.prototype.removeControls = function() {
      if (this.play_button != null) {
        this.play_button.remove();
      }
      if (this.stop_button != null) {
        this.stop_button.remove();
      }
      if (this.paper != null) {
        return this.paper.view.draw();
      }
    };
  


    Player.prototype.render = function() {
      var abs_tick, data, i, key, max_voice_tick, note, overlay, staves, total_ticks, total_voice_ticks, voice, voice_group, _i, _j, _k, _len, _len1, _len2, _ref;
      this.reset();
      data = this.artist.getPlayerData();
      this.scale = data.scale;
      if (!this.paper) {
        overlay = getOverlay(data.context, data.scale, this.options.overlay_class);
        this.paper = overlay.paper;
      }
      this.marker = new this.paper.Path.Rectangle(0, 0, 13, 85);
      this.loading_message = new this.paper.PointText(35, 12);
      if (this.options.show_controls) {
        this.play_button = new this.paper.Path.RegularPolygon(new this.paper.Point(25, 10), 3, 7, 7);
        this.play_button.fillColor = '#396';
        this.play_button.opacity = 0.8;
        this.play_button.rotate(90);
        this.play_button.onMouseUp = (function(_this) {
          return function(event) {
            return _this.play();
          };
        })(this);
        this.stop_button = new this.paper.Path.Rectangle(3, 3, 10, 10);
        this.stop_button.fillColor = '#396';
        this.stop_button.opacity = 0.8;
        this.stop_button.onMouseUp = (function(_this) {
          return function(event) {
            return _this.stop();
          };
        })(this);
      }
      this.paper.view.draw();
      staves = data.voices;
      total_ticks = new Fraction(0, 1);
      for (_i = 0, _len = staves.length; _i < _len; _i++) {
        voice_group = staves[_i];
        max_voice_tick = new Fraction(0, 1);
        for (i = _j = 0, _len1 = voice_group.length; _j < _len1; i = ++_j) {
          voice = voice_group[i];
          total_voice_ticks = new Fraction(0, 1);
          _ref = voice.getTickables();
          for (_k = 0, _len2 = _ref.length; _k < _len2; _k++) {
            note = _ref[_k];
            if (!note.shouldIgnoreTicks()) {
              abs_tick = total_ticks.clone();
              abs_tick.add(total_voice_ticks);
              abs_tick.simplify();
              key = abs_tick.toString();
              if (_.has(this.tick_notes, key)) {
                this.tick_notes[key].notes.push(note);
              } else {
                this.tick_notes[key] = {
                  tick: abs_tick,
                  value: abs_tick.value(),
                  notes: [note]
                };
              }
              total_voice_ticks.add(note.getTicks());
            }
          }
          if (total_voice_ticks.value() > max_voice_tick.value()) {
            max_voice_tick.copy(total_voice_ticks);
          }
        }
        total_ticks.add(max_voice_tick);
      }
      this.all_ticks = _.sortBy(_.values(this.tick_notes), function(tick) {
        return tick.value;
      });
      this.total_ticks = _.last(this.all_ticks);
      return L(this.all_ticks);
    };

    Player.prototype.updateMarker = function(x, y) {
      this.marker.fillColor = '#369';
      this.marker.opacity = 0.2;
      this.marker.setPosition(new this.paper.Point(x * this.scale, y * this.scale));
      return this.paper.view.draw();
    };

    Player.prototype.playNote = function(notes) {
      var duration, key, keys, midi_note, note, note_value, octave, x, y, _i, _len, _results;
      L("(" + this.current_ticks + ") playNote: ", notes);
      _results = [];
      for (_i = 0, _len = notes.length; _i < _len; _i++) {
        note = notes[_i];
        x = note.getAbsoluteX() + 4;
        y = note.getStave().getYForLine(2);
        if (this.paper != null) {
          this.updateMarker(x, y);
        }
        if (note.isRest()) {
          continue;
        }
        keys = note.getPlayNote();
        duration = note.getTicks().value() / (this.tpm / 60);
        _results.push((function() {
          var _j, _len1, _ref, _results1;
          _results1 = [];
          for (_j = 0, _len1 = keys.length; _j < _len1; _j++) {
            key = keys[_j];
            _ref = key.split("/"), note = _ref[0], octave = _ref[1];
            note = note.trim().toLowerCase();
            note_value = noteValues[note];
            if (note_value == null) {
              continue;
            }
            midi_note = (24 + (octave * 12)) + noteValues[note].int_val;
            MIDI.noteOn(0, midi_note, 127, 0);
            _results1.push(MIDI.noteOff(0, midi_note, duration));
          }
          return _results1;
        })());
      }
      return _results;
    };

    Player.prototype.refresh = function() {
      if (this.done) {
        this.stop();
        return;
      }
      this.current_ticks += this.ticks_per_refresh;
      if (this.current_ticks >= this.next_event_tick) {
        this.playNote(this.all_ticks[this.next_index].notes);
        this.next_index++;
        if (this.next_index >= this.all_ticks.length) {
          return this.done = true;
        } else {
          return this.next_event_tick = this.all_ticks[this.next_index].tick.value();
        }
      }
    };

    Player.prototype.stop = function() {
      L("Stop");
      if (this.interval_id != null) {
        window.clearInterval(this.interval_id);
      }
      if (this.play_button != null) {
        this.play_button.fillColor = '#396';
      }
      if (this.paper != null) {
        this.paper.view.draw();
      }
      this.interval_id = null;
      this.current_ticks = 0;
      this.next_event_tick = 0;
      this.next_index = 0;
      return this.done = false;
    };

    Player.prototype.start = function() {
      this.stop();
      L("Start");
      if (this.play_button != null) {
        this.play_button.fillColor = '#a36';
      }
      MIDI.programChange(0, INSTRUMENTS[this.options.instrument]);
      return this.interval_id = window.setInterval(((function(_this) {
        return function() {
          return _this.refresh();
        };
      })(this)), this.refresh_rate);
    };

    Player.prototype.play = function() {
      L("Play: ", this.refresh_rate, this.ticks_per_refresh);
      if (Vex.Flow.Player.INSTRUMENTS_LOADED[this.options.instrument] && !this.loading) {
        return this.start();
      } else {
        L("Loading instruments...");
        this.loading_message.content = "Loading instruments...";
        this.loading_message.fillColor = "green";
        this.loading = true;
        this.paper.view.draw();
        return MIDI.loadPlugin({
          soundfontUrl: this.options.soundfont_url,
          instruments: [this.options.instrument],
          callback: (function(_this) {
            return function() {
              Vex.Flow.Player.INSTRUMENTS_LOADED[_this.options.instrument] = true;
              _this.loading = false;
              _this.loading_message.content = "";
              return _this.start();
            };
          })(this)
        });
      }
    };

    return Player;

  })();

}).call(this);
