// Generated by CoffeeScript 1.7.1
(function() {
  var __slice = [].slice,
    __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  Vex.Flow.Artist = (function() {
    var L, formatAndRender, getFingering, getScoreArticulationParts, getStrokeParts, makeBend, makeDuration, parseBool;

    Artist.DEBUG = false;

    L = function() {
      var args;
      args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      if (Vex.Flow.Artist.DEBUG) {
        return typeof console !== "undefined" && console !== null ? console.log.apply(console, ["(Vex.Flow.Artist)"].concat(__slice.call(args))) : void 0;
      }
    };

    Artist.NOLOGO = false;

    function Artist(x, y, width, options) {
      this.x = x;
      this.y = y;
      this.width = width;
      this.options = {
        font_face: "Arial",
        font_size: 10,
        font_style: null,
        bottom_spacing: 20 + (Vex.Flow.Artist.NOLOGO ? 0 : 10),
        tab_stave_lower_spacing: 10,
        note_stave_lower_spacing: 0,
        scale: 1.0
      };
      if (options != null) {
        _.extend(this.options, options);
      }
      this.reset();
    }

    Artist.prototype.reset = function() {
      this.tuning = new Vex.Flow.Tuning();
      this.key_manager = new Vex.Flow.KeyManager("C");
      this.music_api = new Vex.Flow.Music();
      this.customizations = {
        "font-size": this.options.font_size,
        "font-face": this.options.font_face,
        "font-style": this.options.font_style,
        "annotation-position": "bottom",
        "scale": this.options.scale,
        "width": this.width,
        "stave-distance": 0,
        "space": 0,
        "player": "false",
        "tempo": 120,
        "instrument": "acoustic_grand_piano",
        "accidentals": "standard",
        "tab-stems": "false",
        "tab-stem-direction": "up",
        "beam-rests": "true",
        "beam-stemlets": "true",
        "beam-middle-only": "false",
        "connector-space": 0
      };
      this.staves = [];
      this.tab_articulations = [];
      this.stave_articulations = [];
      this.player_voices = [];
      this.last_y = this.y;
      this.current_duration = "q";
      this.current_clef = "treble";
      this.current_bends = {};
      this.current_octave_shift = 0;
      this.bend_start_index = null;
      this.bend_start_strings = null;
      this.rendered = false;
      return this.renderer_context = null;
    };

    Artist.prototype.attachPlayer = function(player) {
      return this.player = player;
    };

    Artist.prototype.setOptions = function(options) {
      var k, v, valid_options;
      L("setOptions: ", options);
      valid_options = _.keys(this.customizations);
      for (k in options) {
        v = options[k];
        if (__indexOf.call(valid_options, k) >= 0) {
          this.customizations[k] = v;
        } else {
          throw new Vex.RERR("ArtistError", "Invalid option '" + k + "'");
        }
      }
      this.last_y += parseInt(this.customizations.space, 10);
      if (this.customizations.player === "true") {
        return this.last_y += 15;
      }
    };

    Artist.prototype.getPlayerData = function() {
      return {
        voices: this.player_voices,
        context: this.renderer_context,
        scale: this.customizations.scale
      };
    };

    parseBool = function(str) {
      return str === "true";
    };

    formatAndRender = function(ctx, tab, score, text_notes, customizations, options) {
      var align_rests, beam_config, beams, format_stave, format_voices, formatter, i, multi_voice, notes, score_stave, score_voices, stem_direction, tab_stave, tab_voices, text_stave, text_voices, voice, _i, _j, _k, _len, _len1, _len2, _ref, _ref1;
      if (tab != null) {
        tab_stave = tab.stave;
      }
      if (score != null) {
        score_stave = score.stave;
      }
      tab_voices = [];
      score_voices = [];
      text_voices = [];
      beams = [];
      format_stave = null;
      text_stave = null;
      beam_config = {
        beam_rests: parseBool(customizations["beam-rests"]),
        show_stemlets: parseBool(customizations["beam-stemlets"]),
        beam_middle_only: parseBool(customizations["beam-middle-only"]),
        groups: options.beam_groups
      };
      if (tab != null) {
        multi_voice = tab.voices.length > 1 ? true : false;
        _ref = tab.voices;
        for (i = _i = 0, _len = _ref.length; _i < _len; i = ++_i) {
          notes = _ref[i];
          if (_.isEmpty(notes)) {
            continue;
          }
          _.each(notes, function(note) {
            return note.setStave(tab_stave);
          });
          voice = new Vex.Flow.Voice(Vex.Flow.TIME4_4).setMode(Vex.Flow.Voice.Mode.SOFT);
          voice.addTickables(notes);
          tab_voices.push(voice);
          if (customizations["tab-stems"] === "true") {
            if (multi_voice) {
              beam_config.stem_direction = i === 0 ? 1 : -1;
            } else {
              beam_config.stem_direction = customizations["tab-stem-direction"] === "down" ? -1 : 1;
            }
            beam_config.beam_rests = false;
            beams = beams.concat(Vex.Flow.Beam.generateBeams(voice.getTickables(), beam_config));
          }
        }
        format_stave = tab_stave;
        text_stave = tab_stave;
      }
      beam_config.beam_rests = parseBool(customizations["beam-rests"]);
      if (score != null) {
        multi_voice = score.voices.length > 1 ? true : false;
        _ref1 = score.voices;
        for (i = _j = 0, _len1 = _ref1.length; _j < _len1; i = ++_j) {
          notes = _ref1[i];
          if (_.isEmpty(notes)) {
            continue;
          }
          stem_direction = i === 0 ? 1 : -1;
          _.each(notes, function(note) {
            return note.setStave(score_stave);
          });
          voice = new Vex.Flow.Voice(Vex.Flow.TIME4_4).setMode(Vex.Flow.Voice.Mode.SOFT);
          voice.addTickables(notes);
          score_voices.push(voice);
          if (multi_voice) {
            beam_config.stem_direction = stem_direction;
            beams = beams.concat(Vex.Flow.Beam.generateBeams(notes, beam_config));
          } else {
            beam_config.stem_direction = null;
            beams = beams.concat(Vex.Flow.Beam.generateBeams(notes, beam_config));
          }
        }
        format_stave = score_stave;
        text_stave = score_stave;
      }
      for (_k = 0, _len2 = text_notes.length; _k < _len2; _k++) {
        notes = text_notes[_k];
        if (_.isEmpty(notes)) {
          continue;
        }
        _.each(notes, function(voice) {
          return voice.setStave(text_stave);
        });
        voice = new Vex.Flow.Voice(Vex.Flow.TIME4_4).setMode(Vex.Flow.Voice.Mode.SOFT);
        voice.addTickables(notes);
        text_voices.push(voice);
      }
      if (format_stave != null) {
        format_voices = [];
        formatter = new Vex.Flow.Formatter();
        align_rests = false;
        if (tab != null) {
          if (!_.isEmpty(tab_voices)) {
            formatter.joinVoices(tab_voices);
          }
          format_voices = tab_voices;
        }
        if (score != null) {
          if (!_.isEmpty(score_voices)) {
            formatter.joinVoices(score_voices);
          }
          format_voices = format_voices.concat(score_voices);
          if (score_voices.length > 1) {
            align_rests = true;
          }
        }
        if (!_.isEmpty(text_notes) && !_.isEmpty(text_voices)) {
          formatter.joinVoices(text_voices);
          format_voices = format_voices.concat(text_voices);
        }
        if (!_.isEmpty(format_voices)) {
          formatter.formatToStave(format_voices, format_stave, {
            align_rests: align_rests
          });
        }
        if (tab != null) {
          _.each(tab_voices, function(voice) {
            return voice.draw(ctx, tab_stave);
          });
        }
        if (score != null) {
          _.each(score_voices, function(voice) {
            return voice.draw(ctx, score_stave);
          });
        }
        _.each(beams, function(beam) {
          return beam.setContext(ctx).draw();
        });
        if (!_.isEmpty(text_notes)) {
          _.each(text_voices, function(voice) {
            return voice.draw(ctx, text_stave);
          });
        }
        if ((tab != null) && (score != null)) {
          (new Vex.Flow.StaveConnector(score.stave, tab.stave)).setContext(ctx).draw();
        }
        if (score != null) {
          return score_voices;
        } else {
          return tab_voices;
        }
      }
    };

    Artist.prototype.render = function(renderer) {
      var LOGO, articulation, ctx, setBar, stave, voices, width, _i, _j, _k, _len, _len1, _len2, _ref, _ref1, _ref2;
      L("Render: ", this.options);
      this.closeBends();
      renderer.resize(this.customizations.width * this.customizations.scale, (this.last_y + this.options.bottom_spacing) * this.customizations.scale);
      ctx = renderer.getContext();
      ctx.scale(this.customizations.scale, this.customizations.scale);
      ctx.clear();
      ctx.setFont(this.options.font_face, this.options.font_size, "");
      this.renderer_context = ctx;
      setBar = function(stave, notes) {
        var last_note;
        last_note = _.last(notes);
        if (last_note instanceof Vex.Flow.BarNote) {
          notes.pop();
          return stave.setEndBarType(last_note.getType());
        }
      };
      _ref = this.staves;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        stave = _ref[_i];
        L("Rendering staves.");
        if (stave.tab != null) {
          setBar(stave.tab, stave.tab_notes);
        }
        if (stave.note != null) {
          setBar(stave.note, stave.note_notes);
        }
        if (stave.tab != null) {
          stave.tab.setContext(ctx).draw();
        }
        if (stave.note != null) {
          stave.note.setContext(ctx).draw();
        }
        stave.tab_voices.push(stave.tab_notes);
        stave.note_voices.push(stave.note_notes);
        voices = formatAndRender(ctx, stave.tab != null ? {
          stave: stave.tab,
          voices: stave.tab_voices
        } : null, stave.note != null ? {
          stave: stave.note,
          voices: stave.note_voices
        } : null, stave.text_voices, this.customizations, {
          beam_groups: stave.beam_groups
        });
        this.player_voices.push(voices);
      }
      L("Rendering tab articulations.");
      _ref1 = this.tab_articulations;
      for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
        articulation = _ref1[_j];
        articulation.setContext(ctx).draw();
      }
      L("Rendering note articulations.");
      _ref2 = this.stave_articulations;
      for (_k = 0, _len2 = _ref2.length; _k < _len2; _k++) {
        articulation = _ref2[_k];
        articulation.setContext(ctx).draw();
      }
      if (this.player != null) {
        if (this.customizations.player === "true") {
          this.player.setTempo(parseInt(this.customizations.tempo, 10));
          this.player.setInstrument(this.customizations.instrument);
          this.player.render();
        } else {
          this.player.removeControls();
        }
      }
      this.rendered = true;
      if (!Vex.Flow.Artist.NOLOGO) {
        LOGO = "vexflow.com";
        width = ctx.measureText(LOGO).width;
        ctx.save();
        ctx.setFont("Times", 10, "italic");
        ctx.fillText(LOGO, (this.customizations.width - width) / 2, this.last_y + 25);
        return ctx.restore();
      }
    };

    Artist.prototype.isRendered = function() {
      return this.rendered;
    };

    Artist.prototype.draw = function(renderer) {
      return this.render(renderer);
    };

    Artist.prototype.getNoteForFret = function(fret, string) {
      var accidental, new_note, new_octave, new_root, old_root, selected_note, spec, spec_props;
      spec = this.tuning.getNoteForFret(fret, string);
      spec_props = Vex.Flow.keyProperties(spec);
      selected_note = this.key_manager.selectNote(spec_props.key);
      accidental = null;
      switch (this.customizations.accidentals) {
        case "standard":
          if (selected_note.change) {
            accidental = selected_note.accidental != null ? selected_note.accidental : "n";
          }
          break;
        case "cautionary":
          if (selected_note.change) {
            accidental = selected_note.accidental != null ? selected_note.accidental : "n";
          } else {
            accidental = selected_note.accidental != null ? selected_note.accidental + "_c" : void 0;
          }
          break;
        default:
          throw new Vex.RERR("ArtistError", "Invalid value for option 'accidentals': " + this.customizations.accidentals);
      }
      new_note = selected_note.note;
      new_octave = spec_props.octave;
      old_root = this.music_api.getNoteParts(spec_props.key).root;
      new_root = this.music_api.getNoteParts(selected_note.note).root;
      if (new_root === "b" && old_root === "c") {
        new_octave--;
      } else if (new_root === "c" && old_root === "b") {
        new_octave++;
      }
      return [new_note, new_octave, accidental];
    };

    Artist.prototype.getNoteForABC = function(abc, string) {
      var accidental, key, octave;
      key = abc.key;
      octave = string;
      accidental = abc.accidental;
      if (abc.accidental_type != null) {
        accidental += "_" + abc.accidental_type;
      }
      return [key, octave, accidental];
    };

    Artist.prototype.addStaveNote = function(note_params) {
      var acc, index, new_accidental, params, parts, stave_note, stave_notes, _i, _len, _ref;
      params = {
        is_rest: false,
        play_note: null
      };
      _.extend(params, note_params);
      stave_notes = _.last(this.staves).note_notes;
      stave_note = new Vex.Flow.StaveNote({
        keys: params.spec,
        duration: this.current_duration + (params.is_rest ? "r" : ""),
        clef: params.is_rest ? "treble" : this.current_clef,
        auto_stem: params.is_rest ? false : true
      });
      _ref = params.accidentals;
      for (index = _i = 0, _len = _ref.length; _i < _len; index = ++_i) {
        acc = _ref[index];
        if (acc != null) {
          parts = acc.split("_");
          new_accidental = new Vex.Flow.Accidental(parts[0]);
          if (parts.length > 1 && parts[1] === "c") {
            new_accidental.setAsCautionary();
          }
          stave_note.addAccidental(index, new_accidental);
        }
      }
      if (this.current_duration[this.current_duration.length - 1] === "d") {
        stave_note.addDotToAll();
      }
      if (params.play_note != null) {
        stave_note.setPlayNote(params.play_note);
      }
      return stave_notes.push(stave_note);
    };

    Artist.prototype.addTabNote = function(spec, play_note) {
      var new_tab_note, tab_notes;
      if (play_note == null) {
        play_note = null;
      }
      tab_notes = _.last(this.staves).tab_notes;
      new_tab_note = new Vex.Flow.TabNote({
        positions: spec,
        duration: this.current_duration
      }, this.customizations["tab-stems"] === "true");
      if (play_note != null) {
        new_tab_note.setPlayNote(play_note);
      }
      tab_notes.push(new_tab_note);
      if (this.current_duration[this.current_duration.length - 1] === "d") {
        return new_tab_note.addDot();
      }
    };

    makeDuration = function(time, dot) {
      return time + (dot ? "d" : "");
    };

    Artist.prototype.setDuration = function(time, dot) {
      var t;
      if (dot == null) {
        dot = false;
      }
      t = time.split(/\s+/);
      L("setDuration: ", t[0], dot);
      return this.current_duration = makeDuration(t[0], dot);
    };

    Artist.prototype.addBar = function(type) {
      var TYPE, bar_note, stave;
      L("addBar: ", type);
      this.closeBends();
      this.key_manager.reset();
      stave = _.last(this.staves);
      TYPE = Vex.Flow.Barline.type;
      type = (function() {
        switch (type) {
          case "single":
            return TYPE.SINGLE;
          case "double":
            return TYPE.DOUBLE;
          case "end":
            return TYPE.END;
          case "repeat-begin":
            return TYPE.REPEAT_BEGIN;
          case "repeat-end":
            return TYPE.REPEAT_END;
          case "repeat-both":
            return TYPE.REPEAT_BOTH;
          default:
            return TYPE.SINGLE;
        }
      })();
      bar_note = new Vex.Flow.BarNote().setType(type);
      stave.tab_notes.push(bar_note);
      if (stave.note != null) {
        return stave.note_notes.push(bar_note);
      }
    };

    makeBend = function(from_fret, to_fret) {
      var direction, text;
      direction = Vex.Flow.Bend.UP;
      text = "";
      if (parseInt(from_fret, 10) > parseInt(to_fret, 10)) {
        direction = Vex.Flow.Bend.DOWN;
      } else {
        text = (function() {
          switch (Math.abs(to_fret - from_fret)) {
            case 1:
              return "1/2";
            case 2:
              return "Full";
            case 3:
              return "1 1/2";
            default:
              return "Bend to " + to_fret;
          }
        })();
      }
      return {
        type: direction,
        text: text
      };
    };

    Artist.prototype.openBends = function(first_note, last_note, first_indices, last_indices) {
      var first_frets, from_fret, i, index, last_frets, last_index, start_indices, start_note, tab_notes, to_fret, _base, _i, _len, _results;
      L("openBends", first_note, last_note, first_indices, last_indices);
      tab_notes = _.last(this.staves).tab_notes;
      start_note = first_note;
      start_indices = first_indices;
      if (_.isEmpty(this.current_bends)) {
        this.bend_start_index = tab_notes.length - 2;
        this.bend_start_strings = first_indices;
      } else {
        start_note = tab_notes[this.bend_start_index];
        start_indices = this.bend_start_strings;
      }
      first_frets = start_note.getPositions();
      last_frets = last_note.getPositions();
      _results = [];
      for (i = _i = 0, _len = start_indices.length; _i < _len; i = ++_i) {
        index = start_indices[i];
        last_index = last_indices[i];
        from_fret = first_note.getPositions()[first_indices[i]];
        to_fret = last_frets[last_index];
        if ((_base = this.current_bends)[index] == null) {
          _base[index] = [];
        }
        _results.push(this.current_bends[index].push(makeBend(from_fret.fret, to_fret.fret)));
      }
      return _results;
    };

    Artist.prototype.closeBends = function(offset) {
      var bend, k, phrase, tab_note, tab_notes, v, _i, _j, _len, _len1, _ref, _ref1;
      if (offset == null) {
        offset = 1;
      }
      if (this.bend_start_index == null) {
        return;
      }
      L("closeBends(" + offset + ")");
      tab_notes = _.last(this.staves).tab_notes;
      _ref = this.current_bends;
      for (k in _ref) {
        v = _ref[k];
        phrase = [];
        for (_i = 0, _len = v.length; _i < _len; _i++) {
          bend = v[_i];
          phrase.push(bend);
        }
        tab_notes[this.bend_start_index].addModifier(new Vex.Flow.Bend(null, null, phrase), k);
      }
      _ref1 = tab_notes.slice(this.bend_start_index + 1, +((tab_notes.length - 2) + offset) + 1 || 9e9);
      for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
        tab_note = _ref1[_j];
        tab_note.setGhost(true);
      }
      this.current_bends = {};
      return this.bend_start_index = null;
    };

    Artist.prototype.makeTuplets = function(tuplets, notes) {
      var modifier, stave_notes, tab_modifier, tab_notes;
      L("makeTuplets", tuplets, notes);
      if (notes == null) {
        notes = tuplets;
      }
      if (!_.last(this.staves).note) {
        return;
      }
      stave_notes = _.last(this.staves).note_notes;
      tab_notes = _.last(this.staves).tab_notes;
      if (stave_notes.length < notes) {
        throw new Vex.RERR("ArtistError", "Not enough notes for tuplet");
      }
      modifier = new Vex.Flow.Tuplet(stave_notes.slice(stave_notes.length - notes), {
        num_notes: tuplets
      });
      this.stave_articulations.push(modifier);
      tab_modifier = new Vex.Flow.Tuplet(tab_notes.slice(tab_notes.length - notes), {
        num_notes: tuplets
      });
      if (this.customizations["tab-stems"] === "true") {
        return this.tab_articulations.push(tab_modifier);
      }
    };

    getFingering = function(text) {
      return text.match(/^\.fingering\/([^.]+)\./);
    };

    Artist.prototype.makeFingering = function(text) {
      var POS, badFingering, finger, fingering, fingers, modifier, note_number, number, p, parts, pieces, position, _i, _len;
      parts = getFingering(text);
      POS = Vex.Flow.Modifier.Position;
      fingers = [];
      fingering = [];
      if (parts != null) {
        fingers = (function() {
          var _i, _len, _ref, _results;
          _ref = parts[1].split(/-/);
          _results = [];
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            p = _ref[_i];
            _results.push(p.trim());
          }
          return _results;
        })();
      } else {
        return null;
      }
      badFingering = function() {
        return new Vex.RERR("ArtistError", "Bad fingering: " + parts[1]);
      };
      for (_i = 0, _len = fingers.length; _i < _len; _i++) {
        finger = fingers[_i];
        pieces = finger.match(/(\d+):([ablr]):([fs]):([^-.]+)/);
        if (pieces == null) {
          throw badFingering();
        }
        note_number = parseInt(pieces[1], 10) - 1;
        position = POS.RIGHT;
        switch (pieces[2]) {
          case "l":
            position = POS.LEFT;
            break;
          case "r":
            position = POS.RIGHT;
            break;
          case "a":
            position = POS.ABOVE;
            break;
          case "b":
            position = POS.BELOW;
        }
        modifier = null;
        number = pieces[4];
        switch (pieces[3]) {
          case "s":
            modifier = new Vex.Flow.StringNumber(number).setPosition(position);
            break;
          case "f":
            modifier = new Vex.Flow.FretHandFinger(number).setPosition(position);
        }
        fingering.push({
          num: note_number,
          modifier: modifier
        });
      }
      return fingering;
    };

    getStrokeParts = function(text) {
      return text.match(/^\.stroke\/([^.]+)\./);
    };

    Artist.prototype.makeStroke = function(text) {
      var TYPE, parts, type;
      parts = getStrokeParts(text);
      TYPE = Vex.Flow.Stroke.Type;
      type = null;
      if (parts != null) {
        switch (parts[1]) {
          case "bu":
            type = TYPE.BRUSH_UP;
            break;
          case "bd":
            type = TYPE.BRUSH_DOWN;
            break;
          case "ru":
            type = TYPE.ROLL_UP;
            break;
          case "rd":
            type = TYPE.ROLL_DOWN;
            break;
          case "qu":
            type = TYPE.RASQUEDO_UP;
            break;
          case "qd":
            type = TYPE.RASQUEDO_DOWN;
            break;
          default:
            throw new Vex.RERR("ArtistError", "Invalid stroke type: " + parts[1]);
        }
        return new Vex.Flow.Stroke(type);
      } else {
        return null;
      }
    };

    getScoreArticulationParts = function(text) {
      return text.match(/^\.(a[^\/]*)\/(t|b)[^.]*\./);
    };

    Artist.prototype.makeScoreArticulation = function(text) {
      var POSTYPE, parts, pos, position, type;
      parts = getScoreArticulationParts(text);
      if (parts != null) {
        type = parts[1];
        position = parts[2];
        POSTYPE = Vex.Flow.Modifier.Position;
        pos = position === "t" ? POSTYPE.ABOVE : POSTYPE.BELOW;
        return new Vex.Flow.Articulation(type).setPosition(pos);
      } else {
        return null;
      }
    };

    Artist.prototype.makeAnnotation = function(text) {
      var VJUST, aposition, default_vjust, font_face, font_size, font_style, just, makeIt, parts;
      font_face = this.customizations["font-face"];
      font_size = this.customizations["font-size"];
      font_style = this.customizations["font-style"];
      aposition = this.customizations["annotation-position"];
      VJUST = Vex.Flow.Annotation.VerticalJustify;
      default_vjust = aposition === "top" ? VJUST.TOP : VJUST.BOTTOM;
      makeIt = function(text, just) {
        if (just == null) {
          just = default_vjust;
        }
        return new Vex.Flow.Annotation(text).setFont(font_face, font_size, font_style).setVerticalJustification(just);
      };
      parts = text.match(/^\.([^-]*)-([^-]*)-([^.]*)\.(.*)/);
      if (parts != null) {
        font_face = parts[1];
        font_size = parts[2];
        font_style = parts[3];
        text = parts[4];
        if (text) {
          return makeIt(text);
        } else {
          return null;
        }
      }
      parts = text.match(/^\.([^.]*)\.(.*)/);
      if (parts != null) {
        just = default_vjust;
        text = parts[2];
        switch (parts[1]) {
          case "big":
            font_style = "bold";
            font_size = "14";
            break;
          case "italic":
          case "italics":
            font_face = "Times";
            font_style = "italic";
            break;
          case "medium":
            font_size = "12";
            break;
          case "top":
            just = VJUST.TOP;
            this.customizations["annotation-position"] = "top";
            break;
          case "bottom":
            just = VJUST.BOTTOM;
            this.customizations["annotation-position"] = "bottom";
        }
        if (text) {
          return makeIt(text, just);
        } else {
          return null;
        }
      }
      return makeIt(text);
    };

    Artist.prototype.addAnnotations = function(annotations) {
      var annotation, e, fingering, fingerings, i, note, score_articulation, stave, stave_notes, stroke, tab_note, tab_notes, _i, _j, _k, _len, _len1, _len2, _ref, _ref1, _ref2, _results;
      stave = _.last(this.staves);
      stave_notes = stave.note_notes;
      tab_notes = stave.tab_notes;
      if (annotations.length > tab_notes.length) {
        throw new Vex.RERR("ArtistError", "More annotations than note elements");
      }
      if (stave.tab) {
        _ref = tab_notes.slice(tab_notes.length - annotations.length);
        for (i = _i = 0, _len = _ref.length; _i < _len; i = ++_i) {
          tab_note = _ref[i];
          if (getScoreArticulationParts(annotations[i])) {
            score_articulation = this.makeScoreArticulation(annotations[i]);
            tab_note.addModifier(score_articulation, 0);
          } else if (getStrokeParts(annotations[i])) {
            stroke = this.makeStroke(annotations[i]);
            tab_note.addModifier(stroke, 0);
          } else {
            annotation = this.makeAnnotation(annotations[i]);
            if (annotation) {
              tab_note.addModifier(this.makeAnnotation(annotations[i]), 0);
            }
          }
        }
      } else {
        _ref1 = stave_notes.slice(stave_notes.length - annotations.length);
        for (i = _j = 0, _len1 = _ref1.length; _j < _len1; i = ++_j) {
          note = _ref1[i];
          if (!getScoreArticulationParts(annotations[i])) {
            annotation = this.makeAnnotation(annotations[i]);
            if (annotation) {
              note.addAnnotation(0, this.makeAnnotation(annotations[i]));
            }
          }
        }
      }
      if (stave.note) {
        _ref2 = stave_notes.slice(stave_notes.length - annotations.length);
        _results = [];
        for (i = _k = 0, _len2 = _ref2.length; _k < _len2; i = ++_k) {
          note = _ref2[i];
          score_articulation = this.makeScoreArticulation(annotations[i]);
          if (score_articulation != null) {
            note.addArticulation(0, score_articulation);
          }
          stroke = this.makeStroke(annotations[i]);
          if (stroke != null) {
            note.addStroke(0, stroke);
          }
          fingerings = this.makeFingering(annotations[i]);
          if (fingerings != null) {
            try {
              _results.push((function() {
                var _l, _len3, _results1;
                _results1 = [];
                for (_l = 0, _len3 = fingerings.length; _l < _len3; _l++) {
                  fingering = fingerings[_l];
                  _results1.push(note.addModifier(fingering.num, fingering.modifier));
                }
                return _results1;
              })());
            } catch (_error) {
              e = _error;
              throw new Vex.RERR("ArtistError", "Bad note number in fingering: " + annotations[i]);
            }
          } else {
            _results.push(void 0);
          }
        }
        return _results;
      }
    };

    Artist.prototype.addTabArticulation = function(type, first_note, last_note, first_indices, last_indices) {
      var articulation;
      L("addTabArticulations: ", type, first_note, last_note, first_indices, last_indices);
      if (type === "t") {
        last_note.addModifier(new Vex.Flow.Annotation("T").setVerticalJustification(Vex.Flow.Annotation.VerticalJustify.BOTTOM));
      }
      if (_.isEmpty(first_indices) && _.isEmpty(last_indices)) {
        return;
      }
      articulation = null;
      if (type === "s") {
        articulation = new Vex.Flow.TabSlide({
          first_note: first_note,
          last_note: last_note,
          first_indices: first_indices,
          last_indices: last_indices
        });
      }
      if (type === "h" || type === "p") {
        articulation = new Vex.Flow.TabTie({
          first_note: first_note,
          last_note: last_note,
          first_indices: first_indices,
          last_indices: last_indices
        }, type.toUpperCase());
      }
      if (type === "T" || type === "t") {
        articulation = new Vex.Flow.TabTie({
          first_note: first_note,
          last_note: last_note,
          first_indices: first_indices,
          last_indices: last_indices
        }, " ");
      }
      if (type === "b") {
        this.openBends(first_note, last_note, first_indices, last_indices);
      }
      if (articulation != null) {
        return this.tab_articulations.push(articulation);
      }
    };

    Artist.prototype.addStaveArticulation = function(type, first_note, last_note, first_indices, last_indices) {
      var articulation;
      L("addStaveArticulations: ", type, first_note, last_note, first_indices, last_indices);
      articulation = null;
      if (type === "b" || type === "s" || type === "h" || type === "p" || type === "t" || type === "T") {
        articulation = new Vex.Flow.StaveTie({
          first_note: first_note,
          last_note: last_note,
          first_indices: first_indices,
          last_indices: last_indices
        });
      }
      if (articulation != null) {
        return this.stave_articulations.push(articulation);
      }
    };

    Artist.prototype.getPreviousNoteIndex = function() {
      var index, note, tab_notes;
      tab_notes = _.last(this.staves).tab_notes;
      index = 2;
      while (index <= tab_notes.length) {
        note = tab_notes[tab_notes.length - index];
        if (note instanceof Vex.Flow.TabNote) {
          return tab_notes.length - index;
        }
        index++;
      }
      return -1;
    };

    Artist.prototype.addDecorator = function(decorator) {
      var modifier, score_modifier, score_notes, stave, tab_notes, _ref;
      L("addDecorator: ", decorator);
      if (decorator == null) {
        return;
      }
      stave = _.last(this.staves);
      tab_notes = stave.tab_notes;
      score_notes = stave.note_notes;
      modifier = null;
      score_modifier = null;
      if (decorator === "v") {
        modifier = new Vex.Flow.Vibrato();
      }
      if (decorator === "V") {
        modifier = new Vex.Flow.Vibrato().setHarsh(true);
      }
      if (decorator === "u") {
        modifier = new Vex.Flow.Articulation("a|").setPosition(Vex.Flow.Modifier.Position.BOTTOM);
        score_modifier = new Vex.Flow.Articulation("a|").setPosition(Vex.Flow.Modifier.Position.BOTTOM);
      }
      if (decorator === "d") {
        modifier = new Vex.Flow.Articulation("am").setPosition(Vex.Flow.Modifier.Position.BOTTOM);
        score_modifier = new Vex.Flow.Articulation("am").setPosition(Vex.Flow.Modifier.Position.BOTTOM);
      }
      if (modifier != null) {
        _.last(tab_notes).addModifier(modifier, 0);
      }
      if (score_modifier != null) {
        return (_ref = _.last(score_notes)) != null ? _ref.addArticulation(0, score_modifier) : void 0;
      }
    };

    Artist.prototype.addArticulations = function(articulations) {
      var art, current_indices, current_tab_note, has_bends, i, indices, n, pos, prev_index, prev_indices, prev_tab_note, stave, stave_notes, tab_notes, this_strings, valid_articulation, valid_strings, _i, _len, _ref;
      L("addArticulations: ", articulations);
      stave = _.last(this.staves);
      tab_notes = stave.tab_notes;
      stave_notes = stave.note_notes;
      if (_.isEmpty(tab_notes) || _.isEmpty(articulations)) {
        this.closeBends(0);
        return;
      }
      current_tab_note = _.last(tab_notes);
      has_bends = false;
      _ref = ["b", "s", "h", "p", "t", "T", "v", "V"];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        valid_articulation = _ref[_i];
        indices = (function() {
          var _j, _len1, _results;
          _results = [];
          for (i = _j = 0, _len1 = articulations.length; _j < _len1; i = ++_j) {
            art = articulations[i];
            if ((art != null) && art === valid_articulation) {
              _results.push(i);
            }
          }
          return _results;
        })();
        if (_.isEmpty(indices)) {
          continue;
        }
        if (valid_articulation === "b") {
          has_bends = true;
        }
        prev_index = this.getPreviousNoteIndex();
        if (prev_index === -1) {
          prev_tab_note = null;
          prev_indices = null;
        } else {
          prev_tab_note = tab_notes[prev_index];
          this_strings = (function() {
            var _j, _len1, _ref1, _results;
            _ref1 = current_tab_note.getPositions();
            _results = [];
            for (i = _j = 0, _len1 = _ref1.length; _j < _len1; i = ++_j) {
              n = _ref1[i];
              if (__indexOf.call(indices, i) >= 0) {
                _results.push(n.str);
              }
            }
            return _results;
          })();
          valid_strings = (function() {
            var _j, _len1, _ref1, _ref2, _results;
            _ref1 = prev_tab_note.getPositions();
            _results = [];
            for (i = _j = 0, _len1 = _ref1.length; _j < _len1; i = ++_j) {
              pos = _ref1[i];
              if (_ref2 = pos.str, __indexOf.call(this_strings, _ref2) >= 0) {
                _results.push(pos.str);
              }
            }
            return _results;
          })();
          prev_indices = (function() {
            var _j, _len1, _ref1, _ref2, _results;
            _ref1 = prev_tab_note.getPositions();
            _results = [];
            for (i = _j = 0, _len1 = _ref1.length; _j < _len1; i = ++_j) {
              n = _ref1[i];
              if (_ref2 = n.str, __indexOf.call(valid_strings, _ref2) >= 0) {
                _results.push(i);
              }
            }
            return _results;
          })();
          current_indices = (function() {
            var _j, _len1, _ref1, _ref2, _results;
            _ref1 = current_tab_note.getPositions();
            _results = [];
            for (i = _j = 0, _len1 = _ref1.length; _j < _len1; i = ++_j) {
              n = _ref1[i];
              if (_ref2 = n.str, __indexOf.call(valid_strings, _ref2) >= 0) {
                _results.push(i);
              }
            }
            return _results;
          })();
        }
        if (stave.tab != null) {
          this.addTabArticulation(valid_articulation, prev_tab_note, current_tab_note, prev_indices, current_indices);
        }
        if (stave.note != null) {
          this.addStaveArticulation(valid_articulation, stave_notes[prev_index], _.last(stave_notes), prev_indices, current_indices);
        }
      }
      if (!has_bends) {
        return this.closeBends(0);
      }
    };

    Artist.prototype.addRest = function(params) {
      var position, tab_note, tab_notes;
      L("addRest: ", params);
      this.closeBends();
      if (params["position"] === 0) {
        this.addStaveNote({
          spec: ["r/4"],
          accidentals: [],
          is_rest: true
        });
      } else {
        position = this.tuning.getNoteForFret((parseInt(params["position"], 10) + 5) * 2, 6);
        this.addStaveNote({
          spec: [position],
          accidentals: [],
          is_rest: true
        });
      }
      tab_notes = _.last(this.staves).tab_notes;
      if (this.customizations["tab-stems"] === "true") {
        tab_note = new Vex.Flow.StaveNote({
          keys: [position || "r/4"],
          duration: this.current_duration + "r",
          clef: "treble",
          auto_stem: false
        });
        if (this.current_duration[this.current_duration.length - 1] === "d") {
          tab_note.addDot(0);
        }
        return tab_notes.push(tab_note);
      } else {
        return tab_notes.push(new Vex.Flow.GhostNote(this.current_duration));
      }
    };

    Artist.prototype.addChord = function(chord, chord_articulation, chord_decorator) {
      var acc, accidental, accidentals, art, articulations, current_duration, current_position, current_string, decorators, durations, i, new_note, new_octave, note, num, num_notes, octave, play_note, play_notes, play_octave, saved_duration, spec, specs, stave, tab_specs, _i, _j, _k, _len, _len1, _ref, _ref1, _ref2;
      if (_.isEmpty(chord)) {
        return;
      }
      L("addChord: ", chord);
      stave = _.last(this.staves);
      specs = [];
      play_notes = [];
      accidentals = [];
      articulations = [];
      decorators = [];
      tab_specs = [];
      durations = [];
      num_notes = 0;
      current_string = _.first(chord).string;
      current_position = 0;
      for (_i = 0, _len = chord.length; _i < _len; _i++) {
        note = chord[_i];
        num_notes++;
        if ((note.abc != null) || note.string !== current_string) {
          current_position = 0;
          current_string = note.string;
        }
        if (specs[current_position] == null) {
          specs[current_position] = [];
          play_notes[current_position] = [];
          accidentals[current_position] = [];
          tab_specs[current_position] = [];
          articulations[current_position] = [];
          decorators[current_position] = [];
        }
        _ref = [null, null, null], new_note = _ref[0], new_octave = _ref[1], accidental = _ref[2];
        play_note = null;
        if (note.abc != null) {
          octave = note.octave != null ? note.octave : note.string;
          _ref1 = this.getNoteForABC(note.abc, octave), new_note = _ref1[0], new_octave = _ref1[1], accidental = _ref1[2];
          if (accidental != null) {
            acc = accidental.split("_")[0];
          } else {
            acc = "";
          }
          play_note = "" + new_note + acc;
          if (note.fret == null) {
            note.fret = 'X';
          }
        } else if (note.fret != null) {
          _ref2 = this.getNoteForFret(note.fret, note.string), new_note = _ref2[0], new_octave = _ref2[1], accidental = _ref2[2];
          play_note = this.tuning.getNoteForFret(note.fret, note.string).split("/")[0];
        } else {
          throw new Vex.RERR("ArtistError", "No note specified");
        }
        play_octave = parseInt(new_octave, 10) + this.current_octave_shift;
        current_duration = note.time != null ? {
          time: note.time,
          dot: note.dot
        } : null;
        specs[current_position].push("" + new_note + "/" + new_octave);
        play_notes[current_position].push("" + play_note + "/" + play_octave);
        accidentals[current_position].push(accidental);
        tab_specs[current_position].push({
          fret: note.fret,
          str: note.string
        });
        if (note.articulation != null) {
          articulations[current_position].push(note.articulation);
        }
        durations[current_position] = current_duration;
        if (note.decorator != null) {
          decorators[current_position] = note.decorator;
        }
        current_position++;
      }
      for (i = _j = 0, _len1 = specs.length; _j < _len1; i = ++_j) {
        spec = specs[i];
        saved_duration = this.current_duration;
        if (durations[i] != null) {
          this.setDuration(durations[i].time, durations[i].dot);
        }
        this.addTabNote(tab_specs[i], play_notes[i]);
        if (stave.note != null) {
          this.addStaveNote({
            spec: spec,
            accidentals: accidentals[i],
            play_note: play_notes[i]
          });
        }
        this.addArticulations(articulations[i]);
        if (decorators[i] != null) {
          this.addDecorator(decorators[i]);
        }
      }
      if (chord_articulation != null) {
        art = [];
        for (num = _k = 1; 1 <= num_notes ? _k <= num_notes : _k >= num_notes; num = 1 <= num_notes ? ++_k : --_k) {
          art.push(chord_articulation);
        }
        this.addArticulations(art);
      }
      if (chord_decorator != null) {
        return this.addDecorator(chord_decorator);
      }
    };

    Artist.prototype.addNote = function(note) {
      return this.addChord([note]);
    };

    Artist.prototype.addTextVoice = function() {
      return _.last(this.staves).text_voices.push([]);
    };

    Artist.prototype.setTextFont = function(font) {
      var parts;
      if (font != null) {
        parts = font.match(/([^-]*)-([^-]*)-([^.]*)/);
        if (parts != null) {
          this.customizations["font-face"] = parts[1];
          this.customizations["font-size"] = parseInt(parts[2], 10);
          return this.customizations["font-style"] = parts[3];
        }
      }
    };

    Artist.prototype.addTextNote = function(text, position, justification, smooth, ignore_ticks) {
      var duration, font_face, font_size, font_style, just, note, struct, voices;
      if (position == null) {
        position = 0;
      }
      if (justification == null) {
        justification = "center";
      }
      if (smooth == null) {
        smooth = true;
      }
      if (ignore_ticks == null) {
        ignore_ticks = false;
      }
      voices = _.last(this.staves).text_voices;
      if (_.isEmpty(voices)) {
        throw new Vex.RERR("ArtistError", "Can't add text note without text voice");
      }
      font_face = this.customizations["font-face"];
      font_size = this.customizations["font-size"];
      font_style = this.customizations["font-style"];
      just = (function() {
        switch (justification) {
          case "center":
            return Vex.Flow.TextNote.Justification.CENTER;
          case "left":
            return Vex.Flow.TextNote.Justification.LEFT;
          case "right":
            return Vex.Flow.TextNote.Justification.RIGHT;
          default:
            return Vex.Flow.TextNote.Justification.CENTER;
        }
      })();
      duration = ignore_ticks ? "b" : this.current_duration;
      struct = {
        text: text,
        duration: duration,
        smooth: smooth,
        ignore_ticks: ignore_ticks,
        font: {
          family: font_face,
          size: font_size,
          weight: font_style
        }
      };
      if (text[0] === "#") {
        struct.glyph = text.slice(1);
      }
      note = new Vex.Flow.TextNote(struct).setLine(position).setJustification(just);
      return _.last(voices).push(note);
    };

    Artist.prototype.addVoice = function(options) {
      var stave;
      this.closeBends();
      stave = _.last(this.staves);
      if (stave == null) {
        return this.addStave(options);
      }
      if (!_.isEmpty(stave.tab_notes)) {
        stave.tab_voices.push(stave.tab_notes);
        stave.tab_notes = [];
      }
      if (!_.isEmpty(stave.note_notes)) {
        stave.note_voices.push(stave.note_notes);
        return stave.note_notes = [];
      }
    };

    Artist.prototype.addStave = function(element, options) {
      var beam_groups, note_stave, opts, start_x, tab_stave, tabstave_start_x;
      opts = {
        tuning: "standard",
        clef: "treble",
        key: "C",
        notation: element === "tabstave" ? "false" : "true",
        tablature: element === "stave" ? "false" : "true",
        strings: 6
      };
      _.extend(opts, options);
      L("addStave: ", element, opts);
      tab_stave = null;
      note_stave = null;
      start_x = this.x + this.customizations["connector-space"];
      tabstave_start_x = 40;
      if (opts.notation === "true") {
        note_stave = new Vex.Flow.Stave(start_x, this.last_y, this.customizations.width - 20).addClef(opts.clef).addKeySignature(opts.key);
        if (opts.time != null) {
          note_stave.addTimeSignature(opts.time);
        }
        this.last_y += note_stave.getHeight() + this.options.note_stave_lower_spacing + parseInt(this.customizations["stave-distance"], 10);
        tabstave_start_x = note_stave.getNoteStartX();
        this.current_clef = opts.clef;
      }
      if (opts.tablature === "true") {
        tab_stave = new Vex.Flow.TabStave(start_x, this.last_y, this.customizations.width - 20).setNumLines(opts.strings).addTabGlyph().setNoteStartX(tabstave_start_x);
        this.last_y += tab_stave.getHeight() + this.options.tab_stave_lower_spacing;
      }
      this.closeBends();
      beam_groups = Vex.Flow.Beam.getDefaultBeamGroups(opts.time);
      this.staves.push({
        tab: tab_stave,
        note: note_stave,
        tab_voices: [],
        note_voices: [],
        tab_notes: [],
        note_notes: [],
        text_voices: [],
        beam_groups: beam_groups
      });
      this.tuning.setTuning(opts.tuning);
      this.key_manager.setKey(opts.key);
    };

    Artist.prototype.runCommand = function(line, _l, _c) {
      var words;
      if (_l == null) {
        _l = 0;
      }
      if (_c == null) {
        _c = 0;
      }
      L("runCommand: ", line);
      words = line.split(/\s+/);
      switch (words[0]) {
        case "octave-shift":
          this.current_octave_shift = parseInt(words[1], 10);
          return L("Octave shift: ", this.current_octave_shift);
        default:
          throw new Vex.RERR("ArtistError", "Invalid command '" + words[0] + "' at line " + _l + " column " + _c);
      }
    };

    return Artist;

  })();

}).call(this);
