// @license magnet:?xt=urn:btih:0b31508aeb0634b347b8270c7bee4d411b5d4109&dn=agpl-3.0.txt AGPL-3.0
/*global get_label, page_globals, SHOW_DEBUG, DEDALO_LIB_URL*/
/*eslint no-undef: "error"*/



// imports
	import {event_manager} from '../../common/js/event_manager.js'
	import {ui} from '../../common/js/ui.js'
	import {when_in_viewport,dd_request_idle_callback} from '../../common/js/events.js'
	import {open_tool} from '../../../tools/tool_common/js/tool_common.js'



/**
* VIEW_DEFAULT_EDIT_3D
* Manages the component's logic and appearance in client side
*/
export const view_default_edit_3d = function() {

	return true
}//end view_default_edit_3d



/**
* RENDER
* Render node for use in current view
* @param object self
* @param object options
* @return HTMLElement wrapper
*/
view_default_edit_3d.render = async function(self, options) {

	// options
		const render_level = options.render_level || 'full'

	// content_data
		const content_data = get_content_data_edit(self)
		if (render_level==='content') {
			return content_data
		}

	/// buttons
		const buttons = (self.permissions > 1)
			? get_buttons(self)
			: null

	// wrapper. ui build_edit returns component wrapper
		const wrapper_options = {
			content_data	: content_data,
			buttons			: buttons,
			add_styles		: ['media_wrapper'] // common media classes
		}
		if (self.view==='line') {
			wrapper_options.label = null // prevent to crate label node
		}
		const wrapper = ui.component.build_wrapper_edit(self, wrapper_options)
		// set pointers
		wrapper.content_data = content_data


	return wrapper
}//end render



/**
* GET_CONTENT_DATA_EDIT
* This renders the data
* @param object self
* 	The component_3d instance
* @return HTMLElement content_data
*/
const get_content_data_edit = function(self) {

	// Load threeJS library
	// await self.load_editor_files()

	// short vars
		const data	= self.data || {}  // content generated by the server related to the involving data structure
		const value	= data.value || []  // content generated by the server related to the file itself

	// content_data
		const content_data = ui.component.build_content_data(self)
		// common media classes
		content_data.classList.add('media_content_data')

	// values (inputs)
		const inputs_value	= value || [] // force one empty input at least
		const value_length	= inputs_value.length || 1
		if (value_length>1) {
			console.warn('More than one value in component_3d is not allowed at now. Ignored next values. N values: ', value_length);
		}
		for (let i = 0; i < value_length; i++) {

			const content_value = (self.permissions===1)
				? get_content_value_read(i, inputs_value[i], self)
				: get_content_value(i, inputs_value[i], self)
			content_data.appendChild(content_value)
			// set pointer
			content_data[i] = content_value
			break; // only one is used for the time being
		}


	return content_data
}//end  get_content_data_edit



/**
* GET_CONTENT_VALUE
* @param int i
* 	value key
* @param mixed current_value
* @param object self
* @return HTMLElement content_value
*/
export const get_content_value = (i, current_value, self) => {

	// short vars
		const quality		= self.quality || self.context.features.quality
		const data			= self.data || {}
		const files_info	= current_value && current_value.files_info
			? current_value.files_info
			: []
		const external_source = data.external_source

	// content_value
		const content_value = ui.create_dom_element({
			element_type	: 'div',
			class_name		: 'content_value media_content_value'
		})

	// file_info
		const file_info	= files_info.find(el => el.quality===quality && el.file_exist===true)
		if(file_info) {
			// posterframe image
			const posterframe_url = data.posterframe_url
				? data.posterframe_url + '?t=' + (new Date()).getTime()
				: page_globals.fallback_image
			content_value.posterframe = ui.create_dom_element({
				element_type	: 'img',
				class_name		: 'posterframe loading',
				parent			: content_value
			})
			content_value.posterframe.setAttribute('height', 392)
			// image background color
			content_value.posterframe.addEventListener('load', set_bg_color, false)
			function set_bg_color() {
				this.removeEventListener('load', set_bg_color, false)
				if (content_value.posterframe.src!==page_globals.fallback_image) {
					ui.set_background_image(this, content_value)
				}
			}
			const error_handler = () => {
				if (content_value.posterframe.src !== page_globals.fallback_image) {
					content_value.posterframe.src = page_globals.fallback_image
				}
			}
			content_value.posterframe.addEventListener('error', error_handler)
			// set src url
			content_value.posterframe.src = posterframe_url
		}

	// init viewer when content_value node is in in browser viewport
	const load_viewer = async () => {

		// url
		const file_url = external_source
			? external_source
			: file_info
				? DEDALO_MEDIA_URL + file_info.file_path + '?t=' + (new Date()).getTime()
				: null

		if(file_url) {

			const module = await import('./viewer/viewer.js');

			// viewer_3d
			const viewer_3d = await module.viewer.init({
				cache : false
			})
			// fix viewer
			self.viewer = viewer_3d

			await viewer_3d.build(content_value, {})

			viewer_3d.load(
				file_url  // + '?t=' + (new Date()).getTime()
			) // rootPath, fileMap
			.catch((e) => this.onError(e))
			.then((gltf) => {
				dd_request_idle_callback(
					() => {
						// publish event viewer is ready
						event_manager.publish('viewer_ready_'+self.id, viewer_3d)

						// remove posterframe
						if (content_value.posterframe) {
							content_value.posterframe.remove()
						}
					}
				)
			});

		}else{

			// add fallback image
				const posterframe_url = page_globals.fallback_image
				content_value.posterframe = ui.create_dom_element({
					element_type	: 'img',
					class_name		: 'posterframe',
					parent			: content_value
				})
				// load event. Set image background color
				const load_handler = function(e) {
					this.removeEventListener('load', load_handler, false)
					// if (content_value.posterframe.src!==page_globals.fallback_image) {
					// 	ui.set_background_image(this, content_value)
					// }
				}
				content_value.posterframe.addEventListener('load', load_handler, false)
				content_value.posterframe.src = posterframe_url

			// content_value
				content_value.classList.add('link')
				// mousedown event
				const mousedown_handler = (e) => {
					e.stopPropagation();

					const tool_upload = self.tools.find(el => el.model==='tool_upload')
					// open_tool (tool_common)
					open_tool({
						tool_context	: tool_upload,
						caller			: self
					})
				}
				content_value.addEventListener('mousedown', mousedown_handler);
		}
	};

	// observe in viewport
	when_in_viewport(content_value, dd_request_idle_callback(load_viewer));


	return content_value
}//end get_content_value



/**
* GET_CONTENT_VALUE_READ
* @param int i
* @param mixed current_value
* @param object self
* @return HTMLElement content_value
*/
export const get_content_value_read = (i, current_value, self) => {

	// content_value
		const content_value = ui.create_dom_element({
			element_type	: 'div',
			class_name		: 'content_value media_content_value read_only',
			inner_html		: 'Working in this view ' + self.view
		})

	// posterframe
		const quality		= self.quality || self.context.features.quality
		const data			= self.data || {}
		const files_info	= current_value && current_value.files_info
			? current_value.files_info
			: []
		const file_info	= files_info.find(el => el.quality===quality && el.file_exist===true)
		if(file_info) {
			// posterframe image
			const posterframe_url = data.posterframe_url
				? data.posterframe_url + '?t=' + (new Date()).getTime()
				: page_globals.fallback_image
			content_value.posterframe = ui.create_dom_element({
				element_type	: 'img',
				class_name		: 'posterframe loading',
				parent			: content_value
			})
			// image background color
			content_value.posterframe.addEventListener('load', set_bg_color, false)
			function set_bg_color() {
				this.removeEventListener('load', set_bg_color, false)
				if (content_value.posterframe.src!==page_globals.fallback_image) {
					ui.set_background_image(this, content_value)
				}
			}
			// set source URL
			content_value.posterframe.src = posterframe_url
		}


	return content_value
}//end get_content_value_read



/**
* GET_QUALITY_SELECTOR
* @param object content_value
* @param object self
* @return HTMLElement quality_selector
*/
export const get_quality_selector = (content_value, self) => {

	// short vars
		const data			= self.data || {}
		const value			= data.value || []
		const files_info	= value[0] && value[0].files_info
			? value[0].files_info
			: []
		const quality		= self.quality || self.context.features.quality
		const extension		= self.context.features.extension

	// fragment
		const fragment = new DocumentFragment()

	// create the quality selector
		const quality_selector = ui.create_dom_element({
			element_type	: 'select',
			class_name		: 'quality_selector',
			parent			: fragment
		})
		quality_selector.addEventListener('change', (e) =>{
			const src = e.target.value
		})

		const quality_list		= files_info.filter(el => el.file_exist===true && el.extension===extension)
		const quality_list_len	= quality_list.length
		for (let i = 0; i < quality_list_len; i++) {

			const file_info = quality_list[i]

			// create the node with the all qualities sent by server
			const url = DEDALO_MEDIA_URL + file_info.file_path + '?t=' + (new Date()).getTime()

			const select_option = ui.create_dom_element({
				element_type	: 'option',
				value			: url,
				text_node		: quality_list[i].quality,
				parent			: quality_selector
			})
			//set the default quality_list to config variable dedalo_image_quality_default
			select_option.selected = quality_list[i].quality===quality ? true : false
		}


	return quality_selector
}//end get_quality_selector



/**
* GET_BUTTONS
* @param object instance
* @return HTMLElement buttons_container
*/
export const get_buttons = (self) => {

	// short vars
		const show_interface = self.show_interface

	// fragment
		const fragment = new DocumentFragment()

	// des
		// const button_info = ui.create_dom_element({
		// 	element_type	: 'span',
		// 	class_name 		: 'button full_screen',
		// 	parent 			: fragment
		// })
		// button_info.addEventListener("mouseup", async (e) =>{

		// 	const player_3d = await get_instance({
		// 		model 			: 'component_3d',
		// 		section_tipo	: self.section_tipo,
		// 		section_id		: self.section_id,
		// 		tipo			: self.tipo,
		// 		context			: {},
		// 		mode 			: 'player'
		// 	})

		// 	await player_3d.build(true)

		// 	player_3d.fragment = {tc_in: 3, tc_out: 5}

		// 	const node = await player_3d.render()

		// 	// container, for every ipo will create a li node
		// 		const container = ui.create_dom_element({
		// 			element_type	: 'div'
		// 		})

		// 		self.node[0].appendChild(node)
		// })

	// buttons tools
		if(show_interface.tools === true) {
			ui.add_tools(self, fragment)
		}

	// button_fullscreen
		if(show_interface.button_fullscreen === true){

			const button_fullscreen = ui.create_dom_element({
				element_type	: 'span',
				class_name		: 'button full_screen',
				title			: get_label.full_screen || 'Full screen',
				parent			: fragment
			})
			button_fullscreen.addEventListener('click', function(e) {
				e.stopPropagation()
				ui.enter_fullscreen(self.node)
			})
		}

	// buttons container
		const buttons_container = ui.component.build_buttons_container(self)

	// buttons_fold (allow sticky position on large components)
		const buttons_fold = ui.create_dom_element({
			element_type	: 'div',
			class_name		: 'buttons_fold',
			parent			: buttons_container
		})
		buttons_fold.appendChild(fragment)


	return buttons_container
}//end get_buttons



// @license-end
