// @license magnet:?xt=urn:btih:0b31508aeb0634b347b8270c7bee4d411b5d4109&dn=agpl-3.0.txt AGPL-3.0
/*global get_label, page_globals, SHOW_DEBUG, DEDALO_CORE_URL, DEDALO_API_URL */
/*eslint no-undef: "error"*/



// imports
	import {ui} from '../../../../common/js/ui.js'
	import {dd_request_idle_callback, when_in_viewport} from '../../../../common/js/events.js'


/**
* RENDER_PHP_INFO
* Manages the component's logic and appearance in client side
*/
export const render_php_info = function() {

	return true
}//end render_php_info



/**
* LIST
* Creates the nodes of current widget.
* The created wrapper will be append to the widget body in area_maintenance
* @param object options
* 	Sample:
* 	{
*		render_level : "full"
		render_mode : "list"
*   }
* @return HTMLElement wrapper
* 	To append to the widget body node (area_maintenance)
*/
render_php_info.prototype.list = async function(options) {

	const self = this

	const render_level = options.render_level || 'full'

	// content_data
		const content_data = await get_content_data_edit(self)
		if (render_level==='content') {
			return content_data
		}

	// wrapper. ui build_edit returns widget wrapper
		const wrapper = ui.widget.build_wrapper_edit(self, {
			content_data : content_data
		})
		// set pointers
		wrapper.content_data = content_data


	return wrapper
}//end list



/**
* GET_CONTENT_DATA_EDIT
* @param object self
* @return HTMLElement content_data
*/
const get_content_data_edit = async function(self) {

	// short vars
		const value	= self.value || {}
		const src	= value.src || ''

	// content_data
		const content_data = ui.create_dom_element({
			element_type	: 'iframe',
			class_name		: 'php_info_iframe'
		})

	// load event
		// observe in viewport
		dd_request_idle_callback(
			() => {
				when_in_viewport(content_data, () => {
					content_data.src = src
				})
			}
		)


	return content_data
}//end get_content_data_edit


// @license-end
